
USE BD_Air_France;

-- 313, 7-26

CREATE PROCEDURE P_mes_tables (@liste_table VARCHAR(MAX) OUTPUT) AS
BEGIN
-- variables locales de la procdure
DECLARE @nom_table    VARCHAR(128);
DECLARE curs CURSOR FOR
   SELECT TABLE_NAME
   FROM   INFORMATION_SCHEMA.tables
   WHERE  TABLE_TYPE = 'BASE TABLE';
OPEN curs 
FETCH curs INTO @nom_table
WHILE @@FETCH_STATUS = 0
BEGIN
   SET @liste_table = CONCAT(@liste_table,CONCAT(@nom_table,'-'));
   FETCH curs INTO @nom_table;
END;
CLOSE      curs;
DEALLOCATE curs;
END;
GO

-- il faut des tables prsentes dans votre base

DECLARE @retour   VARCHAR(MAX);
EXEC    P_mes_tables @retour OUTPUT;
PRINT   @retour;

-- 314, 7-27

CREATE TABLE T_Pilote_pil
(pil_brevet VARCHAR(6),
 pil_nom    VARCHAR(20), pil_nbHVol DECIMAL(7,2), cmp_comp VARCHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(pil_brevet));
GO

INSERT INTO T_Pilote_pil VALUES ('PL-1', 'Giaconne', 2450, 'AF');
INSERT INTO T_Pilote_pil VALUES ('PL-2', 'Bardon', 900, 'AF');
INSERT INTO T_Pilote_pil VALUES ('PL-3', 'Mejers', 2500, 'SING');
INSERT INTO T_Pilote_pil VALUES ('PL-4', 'Lhospice', 5500, 'CAST');
INSERT INTO T_Pilote_pil VALUES ('PL-5', 'Calac', 5400, 'AF');
INSERT INTO T_Pilote_pil VALUES ('PL-6', 'Cogne', 2500, 'SING');
GO


CREATE PROCEDURE P_loto_pilotes 
(@pil_nom VARCHAR(20) OUTPUT, @pil_brevet VARCHAR(6) OUTPUT) AS
BEGIN
DECLARE @n  INT;
DECLARE curs SCROLL CURSOR FOR
        SELECT pil_brevet,pil_nom FROM T_Pilote_pil;
OPEN curs
SET @n = 1 + CONVERT(INT,(@@cursor_rows)*RAND())
FETCH ABSOLUTE @n FROM curs INTO @pil_brevet,@pil_nom;
CLOSE      curs;
DEALLOCATE curs;
END;
GO

DECLARE @retour1 VARCHAR(20),
        @retour2 VARCHAR(6);
EXEC    P_loto_pilotes @retour1 OUTPUT,@retour2 OUTPUT;
PRINT   @retour1+'-'+@retour2+' est l''heureux gagnant';

-- 315, 7-28

CREATE PROCEDURE P_dernier_pilote
(@compa VARCHAR(4), @hVol DECIMAL(7,2)) AS
BEGIN
DECLARE @pil_nbHVol  DECIMAL(7,2);
DECLARE curs SCROLL CURSOR FOR
        SELECT pil_nbHVol FROM T_Pilote_pil 
        WHERE cmp_comp = @compa
        ORDER BY pil_nom
        FOR UPDATE OF pil_nbHVol;
OPEN curs
FETCH LAST FROM curs INTO @pil_nbHVol;
IF @@fetch_status = 0
  UPDATE T_Pilote_pil SET pil_nbHVol=pil_nbHVol+@hvol
         WHERE CURRENT OF curs;
CLOSE      curs;
DEALLOCATE curs;
END;
GO

SELECT * FROM T_Pilote_pil WHERE cmp_comp='AF';
DECLARE @p1 VARCHAR(4)   = 'AF',
        @p2 DECIMAL(7,2) = 15.2;
EXEC    P_dernier_pilote @p1,@p2;
SELECT * FROM T_Pilote_pil WHERE cmp_comp='AF';

--

DROP PROCEDURE P_mes_tables;
GO

DROP PROCEDURE P_dernier_pilote;
GO

DROP PROCEDURE P_loto_pilotes ;
GO

DROP TABLE     T_Pilote_pil;
GO